// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the metrics configuration. </summary>
    public readonly partial struct ClusterMetricsConfigurationProvisioningState : IEquatable<ClusterMetricsConfigurationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterMetricsConfigurationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterMetricsConfigurationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string AcceptedValue = "Accepted";
        private const string ProvisioningValue = "Provisioning";

        /// <summary> Succeeded. </summary>
        public static ClusterMetricsConfigurationProvisioningState Succeeded { get; } = new ClusterMetricsConfigurationProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ClusterMetricsConfigurationProvisioningState Failed { get; } = new ClusterMetricsConfigurationProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ClusterMetricsConfigurationProvisioningState Canceled { get; } = new ClusterMetricsConfigurationProvisioningState(CanceledValue);
        /// <summary> Accepted. </summary>
        public static ClusterMetricsConfigurationProvisioningState Accepted { get; } = new ClusterMetricsConfigurationProvisioningState(AcceptedValue);
        /// <summary> Provisioning. </summary>
        public static ClusterMetricsConfigurationProvisioningState Provisioning { get; } = new ClusterMetricsConfigurationProvisioningState(ProvisioningValue);
        /// <summary> Determines if two <see cref="ClusterMetricsConfigurationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ClusterMetricsConfigurationProvisioningState left, ClusterMetricsConfigurationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterMetricsConfigurationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ClusterMetricsConfigurationProvisioningState left, ClusterMetricsConfigurationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterMetricsConfigurationProvisioningState"/>. </summary>
        public static implicit operator ClusterMetricsConfigurationProvisioningState(string value) => new ClusterMetricsConfigurationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterMetricsConfigurationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterMetricsConfigurationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
