// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The more detailed status of the metrics configuration. </summary>
    public readonly partial struct ClusterMetricsConfigurationDetailedStatus : IEquatable<ClusterMetricsConfigurationDetailedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterMetricsConfigurationDetailedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterMetricsConfigurationDetailedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProcessingValue = "Processing";
        private const string AppliedValue = "Applied";
        private const string ErrorValue = "Error";

        /// <summary> Processing. </summary>
        public static ClusterMetricsConfigurationDetailedStatus Processing { get; } = new ClusterMetricsConfigurationDetailedStatus(ProcessingValue);
        /// <summary> Applied. </summary>
        public static ClusterMetricsConfigurationDetailedStatus Applied { get; } = new ClusterMetricsConfigurationDetailedStatus(AppliedValue);
        /// <summary> Error. </summary>
        public static ClusterMetricsConfigurationDetailedStatus Error { get; } = new ClusterMetricsConfigurationDetailedStatus(ErrorValue);
        /// <summary> Determines if two <see cref="ClusterMetricsConfigurationDetailedStatus"/> values are the same. </summary>
        public static bool operator ==(ClusterMetricsConfigurationDetailedStatus left, ClusterMetricsConfigurationDetailedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterMetricsConfigurationDetailedStatus"/> values are not the same. </summary>
        public static bool operator !=(ClusterMetricsConfigurationDetailedStatus left, ClusterMetricsConfigurationDetailedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterMetricsConfigurationDetailedStatus"/>. </summary>
        public static implicit operator ClusterMetricsConfigurationDetailedStatus(string value) => new ClusterMetricsConfigurationDetailedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterMetricsConfigurationDetailedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterMetricsConfigurationDetailedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
