// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The detailed status that provides additional information about the cluster manager. </summary>
    public readonly partial struct ClusterManagerDetailedStatus : IEquatable<ClusterManagerDetailedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterManagerDetailedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterManagerDetailedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ErrorValue = "Error";
        private const string AvailableValue = "Available";
        private const string ProvisioningValue = "Provisioning";
        private const string ProvisioningFailedValue = "ProvisioningFailed";
        private const string UpdatingValue = "Updating";
        private const string UpdateFailedValue = "UpdateFailed";

        /// <summary> Error. </summary>
        public static ClusterManagerDetailedStatus Error { get; } = new ClusterManagerDetailedStatus(ErrorValue);
        /// <summary> Available. </summary>
        public static ClusterManagerDetailedStatus Available { get; } = new ClusterManagerDetailedStatus(AvailableValue);
        /// <summary> Provisioning. </summary>
        public static ClusterManagerDetailedStatus Provisioning { get; } = new ClusterManagerDetailedStatus(ProvisioningValue);
        /// <summary> ProvisioningFailed. </summary>
        public static ClusterManagerDetailedStatus ProvisioningFailed { get; } = new ClusterManagerDetailedStatus(ProvisioningFailedValue);
        /// <summary> Updating. </summary>
        public static ClusterManagerDetailedStatus Updating { get; } = new ClusterManagerDetailedStatus(UpdatingValue);
        /// <summary> UpdateFailed. </summary>
        public static ClusterManagerDetailedStatus UpdateFailed { get; } = new ClusterManagerDetailedStatus(UpdateFailedValue);
        /// <summary> Determines if two <see cref="ClusterManagerDetailedStatus"/> values are the same. </summary>
        public static bool operator ==(ClusterManagerDetailedStatus left, ClusterManagerDetailedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterManagerDetailedStatus"/> values are not the same. </summary>
        public static bool operator !=(ClusterManagerDetailedStatus left, ClusterManagerDetailedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterManagerDetailedStatus"/>. </summary>
        public static implicit operator ClusterManagerDetailedStatus(string value) => new ClusterManagerDetailedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterManagerDetailedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterManagerDetailedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
