// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The latest connectivity status between cluster manager and the cluster. </summary>
    public readonly partial struct ClusterManagerConnectionStatus : IEquatable<ClusterManagerConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterManagerConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterManagerConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConnectedValue = "Connected";
        private const string UnreachableValue = "Unreachable";

        /// <summary> Connected. </summary>
        public static ClusterManagerConnectionStatus Connected { get; } = new ClusterManagerConnectionStatus(ConnectedValue);
        /// <summary> Unreachable. </summary>
        public static ClusterManagerConnectionStatus Unreachable { get; } = new ClusterManagerConnectionStatus(UnreachableValue);
        /// <summary> Determines if two <see cref="ClusterManagerConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(ClusterManagerConnectionStatus left, ClusterManagerConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterManagerConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(ClusterManagerConnectionStatus left, ClusterManagerConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterManagerConnectionStatus"/>. </summary>
        public static implicit operator ClusterManagerConnectionStatus(string value) => new ClusterManagerConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterManagerConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterManagerConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
