// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> ClusterCapacity represents various details regarding compute capacity. </summary>
    public partial class ClusterCapacity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterCapacity"/>. </summary>
        internal ClusterCapacity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClusterCapacity"/>. </summary>
        /// <param name="availableApplianceStorageGB"> The remaining appliance-based storage in GB available for workload use. </param>
        /// <param name="availableCoreCount"> The remaining number of cores that are available in this cluster for workload use. </param>
        /// <param name="availableHostStorageGB"> The remaining machine or host-based storage in GB available for workload use. </param>
        /// <param name="availableMemoryGB"> The remaining memory in GB that are available in this cluster for workload use. </param>
        /// <param name="totalApplianceStorageGB"> The total appliance-based storage in GB supported by this cluster for workload use. </param>
        /// <param name="totalCoreCount"> The total number of cores that are supported by this cluster for workload use. </param>
        /// <param name="totalHostStorageGB"> The total machine or host-based storage in GB supported by this cluster for workload use. </param>
        /// <param name="totalMemoryGB"> The total memory supported by this cluster for workload use. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterCapacity(long? availableApplianceStorageGB, long? availableCoreCount, long? availableHostStorageGB, long? availableMemoryGB, long? totalApplianceStorageGB, long? totalCoreCount, long? totalHostStorageGB, long? totalMemoryGB, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AvailableApplianceStorageGB = availableApplianceStorageGB;
            AvailableCoreCount = availableCoreCount;
            AvailableHostStorageGB = availableHostStorageGB;
            AvailableMemoryGB = availableMemoryGB;
            TotalApplianceStorageGB = totalApplianceStorageGB;
            TotalCoreCount = totalCoreCount;
            TotalHostStorageGB = totalHostStorageGB;
            TotalMemoryGB = totalMemoryGB;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The remaining appliance-based storage in GB available for workload use. </summary>
        public long? AvailableApplianceStorageGB { get; }
        /// <summary> The remaining number of cores that are available in this cluster for workload use. </summary>
        public long? AvailableCoreCount { get; }
        /// <summary> The remaining machine or host-based storage in GB available for workload use. </summary>
        public long? AvailableHostStorageGB { get; }
        /// <summary> The remaining memory in GB that are available in this cluster for workload use. </summary>
        public long? AvailableMemoryGB { get; }
        /// <summary> The total appliance-based storage in GB supported by this cluster for workload use. </summary>
        public long? TotalApplianceStorageGB { get; }
        /// <summary> The total number of cores that are supported by this cluster for workload use. </summary>
        public long? TotalCoreCount { get; }
        /// <summary> The total machine or host-based storage in GB supported by this cluster for workload use. </summary>
        public long? TotalHostStorageGB { get; }
        /// <summary> The total memory supported by this cluster for workload use. </summary>
        public long? TotalMemoryGB { get; }
    }
}
