// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> ClusterAvailableVersion represents the cluster version that the cluster manager can be asked to create and manage. </summary>
    public partial class ClusterAvailableVersion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterAvailableVersion"/>. </summary>
        internal ClusterAvailableVersion()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAvailableVersion"/>. </summary>
        /// <param name="supportExpiryDate"> The last date the version of the platform is supported. </param>
        /// <param name="targetClusterVersion"> The version of the cluster to be deployed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterAvailableVersion(string supportExpiryDate, string targetClusterVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SupportExpiryDate = supportExpiryDate;
            TargetClusterVersion = targetClusterVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The last date the version of the platform is supported. </summary>
        public string SupportExpiryDate { get; }
        /// <summary> The version of the cluster to be deployed. </summary>
        public string TargetClusterVersion { get; }
    }
}
