// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    public partial class ClusterAvailableUpgradeVersion : IUtf8JsonSerializable, IJsonModel<ClusterAvailableUpgradeVersion>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClusterAvailableUpgradeVersion>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClusterAvailableUpgradeVersion>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterAvailableUpgradeVersion>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterAvailableUpgradeVersion)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ControlImpact))
            {
                writer.WritePropertyName("controlImpact"u8);
                writer.WriteStringValue(ControlImpact.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ExpectedDuration))
            {
                writer.WritePropertyName("expectedDuration"u8);
                writer.WriteStringValue(ExpectedDuration);
            }
            if (options.Format != "W" && Optional.IsDefined(ImpactDescription))
            {
                writer.WritePropertyName("impactDescription"u8);
                writer.WriteStringValue(ImpactDescription);
            }
            if (options.Format != "W" && Optional.IsDefined(SupportExpireOn))
            {
                writer.WritePropertyName("supportExpiryDate"u8);
                writer.WriteStringValue(SupportExpireOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(TargetClusterVersion))
            {
                writer.WritePropertyName("targetClusterVersion"u8);
                writer.WriteStringValue(TargetClusterVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(WorkloadImpact))
            {
                writer.WritePropertyName("workloadImpact"u8);
                writer.WriteStringValue(WorkloadImpact.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ClusterAvailableUpgradeVersion IJsonModel<ClusterAvailableUpgradeVersion>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterAvailableUpgradeVersion>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterAvailableUpgradeVersion)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClusterAvailableUpgradeVersion(document.RootElement, options);
        }

        internal static ClusterAvailableUpgradeVersion DeserializeClusterAvailableUpgradeVersion(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ControlImpact? controlImpact = default;
            string expectedDuration = default;
            string impactDescription = default;
            DateTimeOffset? supportExpiryDate = default;
            string targetClusterVersion = default;
            WorkloadImpact? workloadImpact = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("controlImpact"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    controlImpact = new ControlImpact(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("expectedDuration"u8))
                {
                    expectedDuration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("impactDescription"u8))
                {
                    impactDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("supportExpiryDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportExpiryDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("targetClusterVersion"u8))
                {
                    targetClusterVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("workloadImpact"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    workloadImpact = new WorkloadImpact(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClusterAvailableUpgradeVersion(
                controlImpact,
                expectedDuration,
                impactDescription,
                supportExpiryDate,
                targetClusterVersion,
                workloadImpact,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ClusterAvailableUpgradeVersion>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterAvailableUpgradeVersion>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ClusterAvailableUpgradeVersion)} does not support writing '{options.Format}' format.");
            }
        }

        ClusterAvailableUpgradeVersion IPersistableModel<ClusterAvailableUpgradeVersion>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterAvailableUpgradeVersion>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClusterAvailableUpgradeVersion(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClusterAvailableUpgradeVersion)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClusterAvailableUpgradeVersion>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
