// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the cloud services network. </summary>
    public readonly partial struct CloudServicesNetworkProvisioningState : IEquatable<CloudServicesNetworkProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudServicesNetworkProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudServicesNetworkProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string AcceptedValue = "Accepted";

        /// <summary> Succeeded. </summary>
        public static CloudServicesNetworkProvisioningState Succeeded { get; } = new CloudServicesNetworkProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static CloudServicesNetworkProvisioningState Failed { get; } = new CloudServicesNetworkProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static CloudServicesNetworkProvisioningState Canceled { get; } = new CloudServicesNetworkProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static CloudServicesNetworkProvisioningState Provisioning { get; } = new CloudServicesNetworkProvisioningState(ProvisioningValue);
        /// <summary> Accepted. </summary>
        public static CloudServicesNetworkProvisioningState Accepted { get; } = new CloudServicesNetworkProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="CloudServicesNetworkProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CloudServicesNetworkProvisioningState left, CloudServicesNetworkProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudServicesNetworkProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CloudServicesNetworkProvisioningState left, CloudServicesNetworkProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudServicesNetworkProvisioningState"/>. </summary>
        public static implicit operator CloudServicesNetworkProvisioningState(string value) => new CloudServicesNetworkProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudServicesNetworkProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudServicesNetworkProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
