// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of whether the platform default endpoints are allowed for the egress traffic. </summary>
    public readonly partial struct CloudServicesNetworkEnableDefaultEgressEndpoint : IEquatable<CloudServicesNetworkEnableDefaultEgressEndpoint>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudServicesNetworkEnableDefaultEgressEndpoint"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudServicesNetworkEnableDefaultEgressEndpoint(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static CloudServicesNetworkEnableDefaultEgressEndpoint True { get; } = new CloudServicesNetworkEnableDefaultEgressEndpoint(TrueValue);
        /// <summary> False. </summary>
        public static CloudServicesNetworkEnableDefaultEgressEndpoint False { get; } = new CloudServicesNetworkEnableDefaultEgressEndpoint(FalseValue);
        /// <summary> Determines if two <see cref="CloudServicesNetworkEnableDefaultEgressEndpoint"/> values are the same. </summary>
        public static bool operator ==(CloudServicesNetworkEnableDefaultEgressEndpoint left, CloudServicesNetworkEnableDefaultEgressEndpoint right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudServicesNetworkEnableDefaultEgressEndpoint"/> values are not the same. </summary>
        public static bool operator !=(CloudServicesNetworkEnableDefaultEgressEndpoint left, CloudServicesNetworkEnableDefaultEgressEndpoint right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudServicesNetworkEnableDefaultEgressEndpoint"/>. </summary>
        public static implicit operator CloudServicesNetworkEnableDefaultEgressEndpoint(string value) => new CloudServicesNetworkEnableDefaultEgressEndpoint(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudServicesNetworkEnableDefaultEgressEndpoint other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudServicesNetworkEnableDefaultEgressEndpoint other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
