// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The type of bootstrap protocol used. </summary>
    public readonly partial struct BootstrapProtocol : IEquatable<BootstrapProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BootstrapProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BootstrapProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PxeValue = "PXE";

        /// <summary> PXE. </summary>
        public static BootstrapProtocol Pxe { get; } = new BootstrapProtocol(PxeValue);
        /// <summary> Determines if two <see cref="BootstrapProtocol"/> values are the same. </summary>
        public static bool operator ==(BootstrapProtocol left, BootstrapProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BootstrapProtocol"/> values are not the same. </summary>
        public static bool operator !=(BootstrapProtocol left, BootstrapProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BootstrapProtocol"/>. </summary>
        public static implicit operator BootstrapProtocol(string value) => new BootstrapProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BootstrapProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BootstrapProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
