// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the baseboard management controller key set. </summary>
    public readonly partial struct BmcKeySetProvisioningState : IEquatable<BmcKeySetProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BmcKeySetProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BmcKeySetProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string AcceptedValue = "Accepted";
        private const string ProvisioningValue = "Provisioning";

        /// <summary> Succeeded. </summary>
        public static BmcKeySetProvisioningState Succeeded { get; } = new BmcKeySetProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static BmcKeySetProvisioningState Failed { get; } = new BmcKeySetProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static BmcKeySetProvisioningState Canceled { get; } = new BmcKeySetProvisioningState(CanceledValue);
        /// <summary> Accepted. </summary>
        public static BmcKeySetProvisioningState Accepted { get; } = new BmcKeySetProvisioningState(AcceptedValue);
        /// <summary> Provisioning. </summary>
        public static BmcKeySetProvisioningState Provisioning { get; } = new BmcKeySetProvisioningState(ProvisioningValue);
        /// <summary> Determines if two <see cref="BmcKeySetProvisioningState"/> values are the same. </summary>
        public static bool operator ==(BmcKeySetProvisioningState left, BmcKeySetProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BmcKeySetProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(BmcKeySetProvisioningState left, BmcKeySetProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BmcKeySetProvisioningState"/>. </summary>
        public static implicit operator BmcKeySetProvisioningState(string value) => new BmcKeySetProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BmcKeySetProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BmcKeySetProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
