// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    public partial class BgpServiceLoadBalancerConfiguration : IUtf8JsonSerializable, IJsonModel<BgpServiceLoadBalancerConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BgpServiceLoadBalancerConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BgpServiceLoadBalancerConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BgpServiceLoadBalancerConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BgpServiceLoadBalancerConfiguration)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(BgpAdvertisements))
            {
                writer.WritePropertyName("bgpAdvertisements"u8);
                writer.WriteStartArray();
                foreach (var item in BgpAdvertisements)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(BgpPeers))
            {
                writer.WritePropertyName("bgpPeers"u8);
                writer.WriteStartArray();
                foreach (var item in BgpPeers)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(FabricPeeringEnabled))
            {
                writer.WritePropertyName("fabricPeeringEnabled"u8);
                writer.WriteStringValue(FabricPeeringEnabled.Value.ToString());
            }
            if (Optional.IsCollectionDefined(IPAddressPools))
            {
                writer.WritePropertyName("ipAddressPools"u8);
                writer.WriteStartArray();
                foreach (var item in IPAddressPools)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BgpServiceLoadBalancerConfiguration IJsonModel<BgpServiceLoadBalancerConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BgpServiceLoadBalancerConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BgpServiceLoadBalancerConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBgpServiceLoadBalancerConfiguration(document.RootElement, options);
        }

        internal static BgpServiceLoadBalancerConfiguration DeserializeBgpServiceLoadBalancerConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<BgpAdvertisement> bgpAdvertisements = default;
            IList<ServiceLoadBalancerBgpPeer> bgpPeers = default;
            FabricPeeringEnabled? fabricPeeringEnabled = default;
            IList<IPAddressPool> ipAddressPools = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("bgpAdvertisements"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BgpAdvertisement> array = new List<BgpAdvertisement>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BgpAdvertisement.DeserializeBgpAdvertisement(item, options));
                    }
                    bgpAdvertisements = array;
                    continue;
                }
                if (property.NameEquals("bgpPeers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ServiceLoadBalancerBgpPeer> array = new List<ServiceLoadBalancerBgpPeer>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ServiceLoadBalancerBgpPeer.DeserializeServiceLoadBalancerBgpPeer(item, options));
                    }
                    bgpPeers = array;
                    continue;
                }
                if (property.NameEquals("fabricPeeringEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fabricPeeringEnabled = new FabricPeeringEnabled(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("ipAddressPools"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IPAddressPool> array = new List<IPAddressPool>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IPAddressPool.DeserializeIPAddressPool(item, options));
                    }
                    ipAddressPools = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BgpServiceLoadBalancerConfiguration(bgpAdvertisements ?? new ChangeTrackingList<BgpAdvertisement>(), bgpPeers ?? new ChangeTrackingList<ServiceLoadBalancerBgpPeer>(), fabricPeeringEnabled, ipAddressPools ?? new ChangeTrackingList<IPAddressPool>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BgpServiceLoadBalancerConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BgpServiceLoadBalancerConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BgpServiceLoadBalancerConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        BgpServiceLoadBalancerConfiguration IPersistableModel<BgpServiceLoadBalancerConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BgpServiceLoadBalancerConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBgpServiceLoadBalancerConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BgpServiceLoadBalancerConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BgpServiceLoadBalancerConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
