// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator to enable multi-hop peering support. </summary>
    public readonly partial struct BgpMultiHop : IEquatable<BgpMultiHop>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BgpMultiHop"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BgpMultiHop(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static BgpMultiHop True { get; } = new BgpMultiHop(TrueValue);
        /// <summary> False. </summary>
        public static BgpMultiHop False { get; } = new BgpMultiHop(FalseValue);
        /// <summary> Determines if two <see cref="BgpMultiHop"/> values are the same. </summary>
        public static bool operator ==(BgpMultiHop left, BgpMultiHop right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BgpMultiHop"/> values are not the same. </summary>
        public static bool operator !=(BgpMultiHop left, BgpMultiHop right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BgpMultiHop"/>. </summary>
        public static implicit operator BgpMultiHop(string value) => new BgpMultiHop(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BgpMultiHop other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BgpMultiHop other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
