// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator to determine if automatic allocation from the pool should occur. </summary>
    public readonly partial struct BfdEnabled : IEquatable<BfdEnabled>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BfdEnabled"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BfdEnabled(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static BfdEnabled True { get; } = new BfdEnabled(TrueValue);
        /// <summary> False. </summary>
        public static BfdEnabled False { get; } = new BfdEnabled(FalseValue);
        /// <summary> Determines if two <see cref="BfdEnabled"/> values are the same. </summary>
        public static bool operator ==(BfdEnabled left, BfdEnabled right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BfdEnabled"/> values are not the same. </summary>
        public static bool operator !=(BfdEnabled left, BfdEnabled right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BfdEnabled"/>. </summary>
        public static implicit operator BfdEnabled(string value) => new BfdEnabled(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BfdEnabled other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BfdEnabled other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
