// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of whether to skip the graceful OS shutdown and power off the bare metal machine immediately. </summary>
    public readonly partial struct BareMetalMachineSkipShutdown : IEquatable<BareMetalMachineSkipShutdown>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineSkipShutdown"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BareMetalMachineSkipShutdown(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static BareMetalMachineSkipShutdown True { get; } = new BareMetalMachineSkipShutdown(TrueValue);
        /// <summary> False. </summary>
        public static BareMetalMachineSkipShutdown False { get; } = new BareMetalMachineSkipShutdown(FalseValue);
        /// <summary> Determines if two <see cref="BareMetalMachineSkipShutdown"/> values are the same. </summary>
        public static bool operator ==(BareMetalMachineSkipShutdown left, BareMetalMachineSkipShutdown right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BareMetalMachineSkipShutdown"/> values are not the same. </summary>
        public static bool operator !=(BareMetalMachineSkipShutdown left, BareMetalMachineSkipShutdown right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BareMetalMachineSkipShutdown"/>. </summary>
        public static implicit operator BareMetalMachineSkipShutdown(string value) => new BareMetalMachineSkipShutdown(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BareMetalMachineSkipShutdown other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BareMetalMachineSkipShutdown other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
