// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    public partial class BareMetalMachineRunReadCommandsContent : IUtf8JsonSerializable, IJsonModel<BareMetalMachineRunReadCommandsContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BareMetalMachineRunReadCommandsContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BareMetalMachineRunReadCommandsContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BareMetalMachineRunReadCommandsContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BareMetalMachineRunReadCommandsContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("commands"u8);
            writer.WriteStartArray();
            foreach (var item in Commands)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("limitTimeSeconds"u8);
            writer.WriteNumberValue(LimitTimeSeconds);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BareMetalMachineRunReadCommandsContent IJsonModel<BareMetalMachineRunReadCommandsContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BareMetalMachineRunReadCommandsContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BareMetalMachineRunReadCommandsContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBareMetalMachineRunReadCommandsContent(document.RootElement, options);
        }

        internal static BareMetalMachineRunReadCommandsContent DeserializeBareMetalMachineRunReadCommandsContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<BareMetalMachineCommandSpecification> commands = default;
            long limitTimeSeconds = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("commands"u8))
                {
                    List<BareMetalMachineCommandSpecification> array = new List<BareMetalMachineCommandSpecification>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BareMetalMachineCommandSpecification.DeserializeBareMetalMachineCommandSpecification(item, options));
                    }
                    commands = array;
                    continue;
                }
                if (property.NameEquals("limitTimeSeconds"u8))
                {
                    limitTimeSeconds = property.Value.GetInt64();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BareMetalMachineRunReadCommandsContent(commands, limitTimeSeconds, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BareMetalMachineRunReadCommandsContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BareMetalMachineRunReadCommandsContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BareMetalMachineRunReadCommandsContent)} does not support writing '{options.Format}' format.");
            }
        }

        BareMetalMachineRunReadCommandsContent IPersistableModel<BareMetalMachineRunReadCommandsContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BareMetalMachineRunReadCommandsContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBareMetalMachineRunReadCommandsContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BareMetalMachineRunReadCommandsContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BareMetalMachineRunReadCommandsContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
