// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of whether the bare metal machine is ready to receive workloads. </summary>
    public readonly partial struct BareMetalMachineReadyState : IEquatable<BareMetalMachineReadyState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineReadyState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BareMetalMachineReadyState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static BareMetalMachineReadyState True { get; } = new BareMetalMachineReadyState(TrueValue);
        /// <summary> False. </summary>
        public static BareMetalMachineReadyState False { get; } = new BareMetalMachineReadyState(FalseValue);
        /// <summary> Determines if two <see cref="BareMetalMachineReadyState"/> values are the same. </summary>
        public static bool operator ==(BareMetalMachineReadyState left, BareMetalMachineReadyState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BareMetalMachineReadyState"/> values are not the same. </summary>
        public static bool operator !=(BareMetalMachineReadyState left, BareMetalMachineReadyState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BareMetalMachineReadyState"/>. </summary>
        public static implicit operator BareMetalMachineReadyState(string value) => new BareMetalMachineReadyState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BareMetalMachineReadyState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BareMetalMachineReadyState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
