// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the bare metal machine. </summary>
    public readonly partial struct BareMetalMachineProvisioningState : IEquatable<BareMetalMachineProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BareMetalMachineProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string AcceptedValue = "Accepted";

        /// <summary> Succeeded. </summary>
        public static BareMetalMachineProvisioningState Succeeded { get; } = new BareMetalMachineProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static BareMetalMachineProvisioningState Failed { get; } = new BareMetalMachineProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static BareMetalMachineProvisioningState Canceled { get; } = new BareMetalMachineProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static BareMetalMachineProvisioningState Provisioning { get; } = new BareMetalMachineProvisioningState(ProvisioningValue);
        /// <summary> Accepted. </summary>
        public static BareMetalMachineProvisioningState Accepted { get; } = new BareMetalMachineProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="BareMetalMachineProvisioningState"/> values are the same. </summary>
        public static bool operator ==(BareMetalMachineProvisioningState left, BareMetalMachineProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BareMetalMachineProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(BareMetalMachineProvisioningState left, BareMetalMachineProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BareMetalMachineProvisioningState"/>. </summary>
        public static implicit operator BareMetalMachineProvisioningState(string value) => new BareMetalMachineProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BareMetalMachineProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BareMetalMachineProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
