// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of whether the user is currently deployed for access. </summary>
    public readonly partial struct BareMetalMachineKeySetUserSetupStatus : IEquatable<BareMetalMachineKeySetUserSetupStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineKeySetUserSetupStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BareMetalMachineKeySetUserSetupStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string InvalidValue = "Invalid";

        /// <summary> Active. </summary>
        public static BareMetalMachineKeySetUserSetupStatus Active { get; } = new BareMetalMachineKeySetUserSetupStatus(ActiveValue);
        /// <summary> Invalid. </summary>
        public static BareMetalMachineKeySetUserSetupStatus Invalid { get; } = new BareMetalMachineKeySetUserSetupStatus(InvalidValue);
        /// <summary> Determines if two <see cref="BareMetalMachineKeySetUserSetupStatus"/> values are the same. </summary>
        public static bool operator ==(BareMetalMachineKeySetUserSetupStatus left, BareMetalMachineKeySetUserSetupStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BareMetalMachineKeySetUserSetupStatus"/> values are not the same. </summary>
        public static bool operator !=(BareMetalMachineKeySetUserSetupStatus left, BareMetalMachineKeySetUserSetupStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BareMetalMachineKeySetUserSetupStatus"/>. </summary>
        public static implicit operator BareMetalMachineKeySetUserSetupStatus(string value) => new BareMetalMachineKeySetUserSetupStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BareMetalMachineKeySetUserSetupStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BareMetalMachineKeySetUserSetupStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
