// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the bare metal machine key set. </summary>
    public readonly partial struct BareMetalMachineKeySetProvisioningState : IEquatable<BareMetalMachineKeySetProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineKeySetProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BareMetalMachineKeySetProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string AcceptedValue = "Accepted";
        private const string ProvisioningValue = "Provisioning";

        /// <summary> Succeeded. </summary>
        public static BareMetalMachineKeySetProvisioningState Succeeded { get; } = new BareMetalMachineKeySetProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static BareMetalMachineKeySetProvisioningState Failed { get; } = new BareMetalMachineKeySetProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static BareMetalMachineKeySetProvisioningState Canceled { get; } = new BareMetalMachineKeySetProvisioningState(CanceledValue);
        /// <summary> Accepted. </summary>
        public static BareMetalMachineKeySetProvisioningState Accepted { get; } = new BareMetalMachineKeySetProvisioningState(AcceptedValue);
        /// <summary> Provisioning. </summary>
        public static BareMetalMachineKeySetProvisioningState Provisioning { get; } = new BareMetalMachineKeySetProvisioningState(ProvisioningValue);
        /// <summary> Determines if two <see cref="BareMetalMachineKeySetProvisioningState"/> values are the same. </summary>
        public static bool operator ==(BareMetalMachineKeySetProvisioningState left, BareMetalMachineKeySetProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BareMetalMachineKeySetProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(BareMetalMachineKeySetProvisioningState left, BareMetalMachineKeySetProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BareMetalMachineKeySetProvisioningState"/>. </summary>
        public static implicit operator BareMetalMachineKeySetProvisioningState(string value) => new BareMetalMachineKeySetProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BareMetalMachineKeySetProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BareMetalMachineKeySetProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
