// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The access level allowed for the users in this key set. </summary>
    public readonly partial struct BareMetalMachineKeySetPrivilegeLevel : IEquatable<BareMetalMachineKeySetPrivilegeLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineKeySetPrivilegeLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BareMetalMachineKeySetPrivilegeLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string SuperuserValue = "Superuser";

        /// <summary> Standard. </summary>
        public static BareMetalMachineKeySetPrivilegeLevel Standard { get; } = new BareMetalMachineKeySetPrivilegeLevel(StandardValue);
        /// <summary> Superuser. </summary>
        public static BareMetalMachineKeySetPrivilegeLevel Superuser { get; } = new BareMetalMachineKeySetPrivilegeLevel(SuperuserValue);
        /// <summary> Determines if two <see cref="BareMetalMachineKeySetPrivilegeLevel"/> values are the same. </summary>
        public static bool operator ==(BareMetalMachineKeySetPrivilegeLevel left, BareMetalMachineKeySetPrivilegeLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BareMetalMachineKeySetPrivilegeLevel"/> values are not the same. </summary>
        public static bool operator !=(BareMetalMachineKeySetPrivilegeLevel left, BareMetalMachineKeySetPrivilegeLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BareMetalMachineKeySetPrivilegeLevel"/>. </summary>
        public static implicit operator BareMetalMachineKeySetPrivilegeLevel(string value) => new BareMetalMachineKeySetPrivilegeLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BareMetalMachineKeySetPrivilegeLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BareMetalMachineKeySetPrivilegeLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
