// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The more detailed status of the key set. </summary>
    public readonly partial struct BareMetalMachineKeySetDetailedStatus : IEquatable<BareMetalMachineKeySetDetailedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineKeySetDetailedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BareMetalMachineKeySetDetailedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllActiveValue = "AllActive";
        private const string SomeInvalidValue = "SomeInvalid";
        private const string AllInvalidValue = "AllInvalid";
        private const string ValidatingValue = "Validating";

        /// <summary> AllActive. </summary>
        public static BareMetalMachineKeySetDetailedStatus AllActive { get; } = new BareMetalMachineKeySetDetailedStatus(AllActiveValue);
        /// <summary> SomeInvalid. </summary>
        public static BareMetalMachineKeySetDetailedStatus SomeInvalid { get; } = new BareMetalMachineKeySetDetailedStatus(SomeInvalidValue);
        /// <summary> AllInvalid. </summary>
        public static BareMetalMachineKeySetDetailedStatus AllInvalid { get; } = new BareMetalMachineKeySetDetailedStatus(AllInvalidValue);
        /// <summary> Validating. </summary>
        public static BareMetalMachineKeySetDetailedStatus Validating { get; } = new BareMetalMachineKeySetDetailedStatus(ValidatingValue);
        /// <summary> Determines if two <see cref="BareMetalMachineKeySetDetailedStatus"/> values are the same. </summary>
        public static bool operator ==(BareMetalMachineKeySetDetailedStatus left, BareMetalMachineKeySetDetailedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BareMetalMachineKeySetDetailedStatus"/> values are not the same. </summary>
        public static bool operator !=(BareMetalMachineKeySetDetailedStatus left, BareMetalMachineKeySetDetailedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BareMetalMachineKeySetDetailedStatus"/>. </summary>
        public static implicit operator BareMetalMachineKeySetDetailedStatus(string value) => new BareMetalMachineKeySetDetailedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BareMetalMachineKeySetDetailedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BareMetalMachineKeySetDetailedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
