// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The cordon status of the bare metal machine. </summary>
    public readonly partial struct BareMetalMachineCordonStatus : IEquatable<BareMetalMachineCordonStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineCordonStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BareMetalMachineCordonStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CordonedValue = "Cordoned";
        private const string UncordonedValue = "Uncordoned";

        /// <summary> Cordoned. </summary>
        public static BareMetalMachineCordonStatus Cordoned { get; } = new BareMetalMachineCordonStatus(CordonedValue);
        /// <summary> Uncordoned. </summary>
        public static BareMetalMachineCordonStatus Uncordoned { get; } = new BareMetalMachineCordonStatus(UncordonedValue);
        /// <summary> Determines if two <see cref="BareMetalMachineCordonStatus"/> values are the same. </summary>
        public static bool operator ==(BareMetalMachineCordonStatus left, BareMetalMachineCordonStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BareMetalMachineCordonStatus"/> values are not the same. </summary>
        public static bool operator !=(BareMetalMachineCordonStatus left, BareMetalMachineCordonStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BareMetalMachineCordonStatus"/>. </summary>
        public static implicit operator BareMetalMachineCordonStatus(string value) => new BareMetalMachineCordonStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BareMetalMachineCordonStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BareMetalMachineCordonStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
