// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> BareMetalMachineConfigurationData represents configuration for the bare metal machine. </summary>
    public partial class BareMetalMachineConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineConfiguration"/>. </summary>
        /// <param name="bmcCredentials"> The credentials of the baseboard management controller on this bare metal machine. </param>
        /// <param name="bmcMacAddress"> The MAC address of the BMC for this machine. </param>
        /// <param name="bootMacAddress"> The MAC address associated with the PXE NIC card. </param>
        /// <param name="rackSlot"> The slot the physical machine is in the rack based on the BOM configuration. </param>
        /// <param name="serialNumber"> The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="bmcCredentials"/>, <paramref name="bmcMacAddress"/>, <paramref name="bootMacAddress"/> or <paramref name="serialNumber"/> is null. </exception>
        public BareMetalMachineConfiguration(AdministrativeCredentials bmcCredentials, string bmcMacAddress, string bootMacAddress, long rackSlot, string serialNumber)
        {
            Argument.AssertNotNull(bmcCredentials, nameof(bmcCredentials));
            Argument.AssertNotNull(bmcMacAddress, nameof(bmcMacAddress));
            Argument.AssertNotNull(bootMacAddress, nameof(bootMacAddress));
            Argument.AssertNotNull(serialNumber, nameof(serialNumber));

            BmcCredentials = bmcCredentials;
            BmcMacAddress = bmcMacAddress;
            BootMacAddress = bootMacAddress;
            RackSlot = rackSlot;
            SerialNumber = serialNumber;
        }

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineConfiguration"/>. </summary>
        /// <param name="bmcConnectionString"> The connection string for the baseboard management controller including IP address and protocol. </param>
        /// <param name="bmcCredentials"> The credentials of the baseboard management controller on this bare metal machine. </param>
        /// <param name="bmcMacAddress"> The MAC address of the BMC for this machine. </param>
        /// <param name="bootMacAddress"> The MAC address associated with the PXE NIC card. </param>
        /// <param name="machineDetails"> The free-form additional information about the machine, e.g. an asset tag. </param>
        /// <param name="machineName">
        /// The user-provided name for the bare metal machine created from this specification.
        /// If not provided, the machine name will be generated programmatically.
        /// </param>
        /// <param name="rackSlot"> The slot the physical machine is in the rack based on the BOM configuration. </param>
        /// <param name="serialNumber"> The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BareMetalMachineConfiguration(string bmcConnectionString, AdministrativeCredentials bmcCredentials, string bmcMacAddress, string bootMacAddress, string machineDetails, string machineName, long rackSlot, string serialNumber, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BmcConnectionString = bmcConnectionString;
            BmcCredentials = bmcCredentials;
            BmcMacAddress = bmcMacAddress;
            BootMacAddress = bootMacAddress;
            MachineDetails = machineDetails;
            MachineName = machineName;
            RackSlot = rackSlot;
            SerialNumber = serialNumber;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BareMetalMachineConfiguration"/> for deserialization. </summary>
        internal BareMetalMachineConfiguration()
        {
        }

        /// <summary> The connection string for the baseboard management controller including IP address and protocol. </summary>
        public string BmcConnectionString { get; }
        /// <summary> The credentials of the baseboard management controller on this bare metal machine. </summary>
        public AdministrativeCredentials BmcCredentials { get; set; }
        /// <summary> The MAC address of the BMC for this machine. </summary>
        public string BmcMacAddress { get; set; }
        /// <summary> The MAC address associated with the PXE NIC card. </summary>
        public string BootMacAddress { get; set; }
        /// <summary> The free-form additional information about the machine, e.g. an asset tag. </summary>
        public string MachineDetails { get; set; }
        /// <summary>
        /// The user-provided name for the bare metal machine created from this specification.
        /// If not provided, the machine name will be generated programmatically.
        /// </summary>
        public string MachineName { get; set; }
        /// <summary> The slot the physical machine is in the rack based on the BOM configuration. </summary>
        public long RackSlot { get; set; }
        /// <summary> The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag. </summary>
        public string SerialNumber { get; set; }
    }
}
