// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    public partial class BareMetalMachineConfiguration : IUtf8JsonSerializable, IJsonModel<BareMetalMachineConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BareMetalMachineConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BareMetalMachineConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BareMetalMachineConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BareMetalMachineConfiguration)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(BmcConnectionString))
            {
                writer.WritePropertyName("bmcConnectionString"u8);
                writer.WriteStringValue(BmcConnectionString);
            }
            writer.WritePropertyName("bmcCredentials"u8);
            writer.WriteObjectValue(BmcCredentials, options);
            writer.WritePropertyName("bmcMacAddress"u8);
            writer.WriteStringValue(BmcMacAddress);
            writer.WritePropertyName("bootMacAddress"u8);
            writer.WriteStringValue(BootMacAddress);
            if (Optional.IsDefined(MachineDetails))
            {
                writer.WritePropertyName("machineDetails"u8);
                writer.WriteStringValue(MachineDetails);
            }
            if (Optional.IsDefined(MachineName))
            {
                writer.WritePropertyName("machineName"u8);
                writer.WriteStringValue(MachineName);
            }
            writer.WritePropertyName("rackSlot"u8);
            writer.WriteNumberValue(RackSlot);
            writer.WritePropertyName("serialNumber"u8);
            writer.WriteStringValue(SerialNumber);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BareMetalMachineConfiguration IJsonModel<BareMetalMachineConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BareMetalMachineConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BareMetalMachineConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBareMetalMachineConfiguration(document.RootElement, options);
        }

        internal static BareMetalMachineConfiguration DeserializeBareMetalMachineConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string bmcConnectionString = default;
            AdministrativeCredentials bmcCredentials = default;
            string bmcMacAddress = default;
            string bootMacAddress = default;
            string machineDetails = default;
            string machineName = default;
            long rackSlot = default;
            string serialNumber = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("bmcConnectionString"u8))
                {
                    bmcConnectionString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("bmcCredentials"u8))
                {
                    bmcCredentials = AdministrativeCredentials.DeserializeAdministrativeCredentials(property.Value, options);
                    continue;
                }
                if (property.NameEquals("bmcMacAddress"u8))
                {
                    bmcMacAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("bootMacAddress"u8))
                {
                    bootMacAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("machineDetails"u8))
                {
                    machineDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("machineName"u8))
                {
                    machineName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("rackSlot"u8))
                {
                    rackSlot = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("serialNumber"u8))
                {
                    serialNumber = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BareMetalMachineConfiguration(
                bmcConnectionString,
                bmcCredentials,
                bmcMacAddress,
                bootMacAddress,
                machineDetails,
                machineName,
                rackSlot,
                serialNumber,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BareMetalMachineConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BareMetalMachineConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BareMetalMachineConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        BareMetalMachineConfiguration IPersistableModel<BareMetalMachineConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BareMetalMachineConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBareMetalMachineConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BareMetalMachineConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BareMetalMachineConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
