// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The version lifecycle indicator. </summary>
    public readonly partial struct AvailabilityLifecycle : IEquatable<AvailabilityLifecycle>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvailabilityLifecycle"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvailabilityLifecycle(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PreviewValue = "Preview";
        private const string GenerallyAvailableValue = "GenerallyAvailable";

        /// <summary> Preview. </summary>
        public static AvailabilityLifecycle Preview { get; } = new AvailabilityLifecycle(PreviewValue);
        /// <summary> GenerallyAvailable. </summary>
        public static AvailabilityLifecycle GenerallyAvailable { get; } = new AvailabilityLifecycle(GenerallyAvailableValue);
        /// <summary> Determines if two <see cref="AvailabilityLifecycle"/> values are the same. </summary>
        public static bool operator ==(AvailabilityLifecycle left, AvailabilityLifecycle right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvailabilityLifecycle"/> values are not the same. </summary>
        public static bool operator !=(AvailabilityLifecycle left, AvailabilityLifecycle right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvailabilityLifecycle"/>. </summary>
        public static implicit operator AvailabilityLifecycle(string value) => new AvailabilityLifecycle(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvailabilityLifecycle other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvailabilityLifecycle other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
