// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> AttachedNetworkConfiguration represents the set of workload networks to attach to a resource. </summary>
    public partial class AttachedNetworkConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AttachedNetworkConfiguration"/>. </summary>
        public AttachedNetworkConfiguration()
        {
            L2Networks = new ChangeTrackingList<L2NetworkAttachmentConfiguration>();
            L3Networks = new ChangeTrackingList<L3NetworkAttachmentConfiguration>();
            TrunkedNetworks = new ChangeTrackingList<TrunkedNetworkAttachmentConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="AttachedNetworkConfiguration"/>. </summary>
        /// <param name="l2Networks"> The list of Layer 2 Networks and related configuration for attachment. </param>
        /// <param name="l3Networks"> The list of Layer 3 Networks and related configuration for attachment. </param>
        /// <param name="trunkedNetworks"> The list of Trunked Networks and related configuration for attachment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AttachedNetworkConfiguration(IList<L2NetworkAttachmentConfiguration> l2Networks, IList<L3NetworkAttachmentConfiguration> l3Networks, IList<TrunkedNetworkAttachmentConfiguration> trunkedNetworks, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            L2Networks = l2Networks;
            L3Networks = l3Networks;
            TrunkedNetworks = trunkedNetworks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The list of Layer 2 Networks and related configuration for attachment. </summary>
        public IList<L2NetworkAttachmentConfiguration> L2Networks { get; }
        /// <summary> The list of Layer 3 Networks and related configuration for attachment. </summary>
        public IList<L3NetworkAttachmentConfiguration> L3Networks { get; }
        /// <summary> The list of Trunked Networks and related configuration for attachment. </summary>
        public IList<TrunkedNetworkAttachmentConfiguration> TrunkedNetworks { get; }
    }
}
