// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudVolumeOperationSource : IOperationSource<NetworkCloudVolumeResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudVolumeOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudVolumeResource IOperationSource<NetworkCloudVolumeResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudVolumeData.DeserializeNetworkCloudVolumeData(document.RootElement);
            return new NetworkCloudVolumeResource(_client, data);
        }

        async ValueTask<NetworkCloudVolumeResource> IOperationSource<NetworkCloudVolumeResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudVolumeData.DeserializeNetworkCloudVolumeData(document.RootElement);
            return new NetworkCloudVolumeResource(_client, data);
        }
    }
}
