// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudVirtualMachineOperationSource : IOperationSource<NetworkCloudVirtualMachineResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudVirtualMachineOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudVirtualMachineResource IOperationSource<NetworkCloudVirtualMachineResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudVirtualMachineData.DeserializeNetworkCloudVirtualMachineData(document.RootElement);
            return new NetworkCloudVirtualMachineResource(_client, data);
        }

        async ValueTask<NetworkCloudVirtualMachineResource> IOperationSource<NetworkCloudVirtualMachineResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudVirtualMachineData.DeserializeNetworkCloudVirtualMachineData(document.RootElement);
            return new NetworkCloudVirtualMachineResource(_client, data);
        }
    }
}
