// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudTrunkedNetworkOperationSource : IOperationSource<NetworkCloudTrunkedNetworkResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudTrunkedNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudTrunkedNetworkResource IOperationSource<NetworkCloudTrunkedNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudTrunkedNetworkData.DeserializeNetworkCloudTrunkedNetworkData(document.RootElement);
            return new NetworkCloudTrunkedNetworkResource(_client, data);
        }

        async ValueTask<NetworkCloudTrunkedNetworkResource> IOperationSource<NetworkCloudTrunkedNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudTrunkedNetworkData.DeserializeNetworkCloudTrunkedNetworkData(document.RootElement);
            return new NetworkCloudTrunkedNetworkResource(_client, data);
        }
    }
}
