// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudRackOperationSource : IOperationSource<NetworkCloudRackResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudRackOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudRackResource IOperationSource<NetworkCloudRackResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudRackData.DeserializeNetworkCloudRackData(document.RootElement);
            return new NetworkCloudRackResource(_client, data);
        }

        async ValueTask<NetworkCloudRackResource> IOperationSource<NetworkCloudRackResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudRackData.DeserializeNetworkCloudRackData(document.RootElement);
            return new NetworkCloudRackResource(_client, data);
        }
    }
}
