// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.NetworkCloud.Models;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudOperationStatusResultOperationSource : IOperationSource<NetworkCloudOperationStatusResult>
    {
        NetworkCloudOperationStatusResult IOperationSource<NetworkCloudOperationStatusResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return NetworkCloudOperationStatusResult.DeserializeNetworkCloudOperationStatusResult(document.RootElement);
        }

        async ValueTask<NetworkCloudOperationStatusResult> IOperationSource<NetworkCloudOperationStatusResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return NetworkCloudOperationStatusResult.DeserializeNetworkCloudOperationStatusResult(document.RootElement);
        }
    }
}
