// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudL3NetworkOperationSource : IOperationSource<NetworkCloudL3NetworkResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudL3NetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudL3NetworkResource IOperationSource<NetworkCloudL3NetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudL3NetworkData.DeserializeNetworkCloudL3NetworkData(document.RootElement);
            return new NetworkCloudL3NetworkResource(_client, data);
        }

        async ValueTask<NetworkCloudL3NetworkResource> IOperationSource<NetworkCloudL3NetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudL3NetworkData.DeserializeNetworkCloudL3NetworkData(document.RootElement);
            return new NetworkCloudL3NetworkResource(_client, data);
        }
    }
}
