// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudL2NetworkOperationSource : IOperationSource<NetworkCloudL2NetworkResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudL2NetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudL2NetworkResource IOperationSource<NetworkCloudL2NetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudL2NetworkData.DeserializeNetworkCloudL2NetworkData(document.RootElement);
            return new NetworkCloudL2NetworkResource(_client, data);
        }

        async ValueTask<NetworkCloudL2NetworkResource> IOperationSource<NetworkCloudL2NetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudL2NetworkData.DeserializeNetworkCloudL2NetworkData(document.RootElement);
            return new NetworkCloudL2NetworkResource(_client, data);
        }
    }
}
