// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudKubernetesClusterOperationSource : IOperationSource<NetworkCloudKubernetesClusterResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudKubernetesClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudKubernetesClusterResource IOperationSource<NetworkCloudKubernetesClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudKubernetesClusterData.DeserializeNetworkCloudKubernetesClusterData(document.RootElement);
            return new NetworkCloudKubernetesClusterResource(_client, data);
        }

        async ValueTask<NetworkCloudKubernetesClusterResource> IOperationSource<NetworkCloudKubernetesClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudKubernetesClusterData.DeserializeNetworkCloudKubernetesClusterData(document.RootElement);
            return new NetworkCloudKubernetesClusterResource(_client, data);
        }
    }
}
