// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudClusterOperationSource : IOperationSource<NetworkCloudClusterResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudClusterResource IOperationSource<NetworkCloudClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudClusterData.DeserializeNetworkCloudClusterData(document.RootElement);
            return new NetworkCloudClusterResource(_client, data);
        }

        async ValueTask<NetworkCloudClusterResource> IOperationSource<NetworkCloudClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudClusterData.DeserializeNetworkCloudClusterData(document.RootElement);
            return new NetworkCloudClusterResource(_client, data);
        }
    }
}
