// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudCloudServicesNetworkOperationSource : IOperationSource<NetworkCloudCloudServicesNetworkResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudCloudServicesNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudCloudServicesNetworkResource IOperationSource<NetworkCloudCloudServicesNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudCloudServicesNetworkData.DeserializeNetworkCloudCloudServicesNetworkData(document.RootElement);
            return new NetworkCloudCloudServicesNetworkResource(_client, data);
        }

        async ValueTask<NetworkCloudCloudServicesNetworkResource> IOperationSource<NetworkCloudCloudServicesNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudCloudServicesNetworkData.DeserializeNetworkCloudCloudServicesNetworkData(document.RootElement);
            return new NetworkCloudCloudServicesNetworkResource(_client, data);
        }
    }
}
