// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud
{
    internal class NetworkCloudBmcKeySetOperationSource : IOperationSource<NetworkCloudBmcKeySetResource>
    {
        private readonly ArmClient _client;

        internal NetworkCloudBmcKeySetOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkCloudBmcKeySetResource IOperationSource<NetworkCloudBmcKeySetResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkCloudBmcKeySetData.DeserializeNetworkCloudBmcKeySetData(document.RootElement);
            return new NetworkCloudBmcKeySetResource(_client, data);
        }

        async ValueTask<NetworkCloudBmcKeySetResource> IOperationSource<NetworkCloudBmcKeySetResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkCloudBmcKeySetData.DeserializeNetworkCloudBmcKeySetData(document.RootElement);
            return new NetworkCloudBmcKeySetResource(_client, data);
        }
    }
}
