// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> The details for role assignment response. </summary>
    public partial class RoleAssignmentDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoleAssignmentDetail"/>. </summary>
        /// <param name="roleId"> Role Id of the Built-In Role. </param>
        /// <param name="principalId"> Object ID of the AAD principal or security-group. </param>
        /// <param name="userName"> User name. </param>
        /// <param name="dataTypeScope"> Data Type Scope at which the role assignment is created. </param>
        /// <param name="principalType"> Type of the principal Id: User, Group or ServicePrincipal. </param>
        /// <param name="role"> Data Product role to be assigned to a user. </param>
        /// <param name="roleAssignmentId"> Id of role assignment request. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="roleId"/>, <paramref name="principalId"/>, <paramref name="userName"/>, <paramref name="dataTypeScope"/>, <paramref name="principalType"/> or <paramref name="roleAssignmentId"/> is null. </exception>
        public RoleAssignmentDetail(string roleId, string principalId, string userName, IEnumerable<string> dataTypeScope, string principalType, DataProductUserRole role, string roleAssignmentId)
        {
            Argument.AssertNotNull(roleId, nameof(roleId));
            Argument.AssertNotNull(principalId, nameof(principalId));
            Argument.AssertNotNull(userName, nameof(userName));
            Argument.AssertNotNull(dataTypeScope, nameof(dataTypeScope));
            Argument.AssertNotNull(principalType, nameof(principalType));
            Argument.AssertNotNull(roleAssignmentId, nameof(roleAssignmentId));

            RoleId = roleId;
            PrincipalId = principalId;
            UserName = userName;
            DataTypeScope = dataTypeScope.ToList();
            PrincipalType = principalType;
            Role = role;
            RoleAssignmentId = roleAssignmentId;
        }

        /// <summary> Initializes a new instance of <see cref="RoleAssignmentDetail"/>. </summary>
        /// <param name="roleId"> Role Id of the Built-In Role. </param>
        /// <param name="principalId"> Object ID of the AAD principal or security-group. </param>
        /// <param name="userName"> User name. </param>
        /// <param name="dataTypeScope"> Data Type Scope at which the role assignment is created. </param>
        /// <param name="principalType"> Type of the principal Id: User, Group or ServicePrincipal. </param>
        /// <param name="role"> Data Product role to be assigned to a user. </param>
        /// <param name="roleAssignmentId"> Id of role assignment request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoleAssignmentDetail(string roleId, string principalId, string userName, IList<string> dataTypeScope, string principalType, DataProductUserRole role, string roleAssignmentId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RoleId = roleId;
            PrincipalId = principalId;
            UserName = userName;
            DataTypeScope = dataTypeScope;
            PrincipalType = principalType;
            Role = role;
            RoleAssignmentId = roleAssignmentId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RoleAssignmentDetail"/> for deserialization. </summary>
        internal RoleAssignmentDetail()
        {
        }

        /// <summary> Role Id of the Built-In Role. </summary>
        public string RoleId { get; set; }
        /// <summary> Object ID of the AAD principal or security-group. </summary>
        public string PrincipalId { get; set; }
        /// <summary> User name. </summary>
        public string UserName { get; set; }
        /// <summary> Data Type Scope at which the role assignment is created. </summary>
        public IList<string> DataTypeScope { get; }
        /// <summary> Type of the principal Id: User, Group or ServicePrincipal. </summary>
        public string PrincipalType { get; set; }
        /// <summary> Data Product role to be assigned to a user. </summary>
        public DataProductUserRole Role { get; set; }
        /// <summary> Id of role assignment request. </summary>
        public string RoleAssignmentId { get; set; }
    }
}
