// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> Details for Publisher Information. </summary>
    public partial class PublisherInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PublisherInformation"/>. </summary>
        /// <param name="publisherName"> Name of the publisher. </param>
        /// <param name="dataProducts"> Data product information. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="publisherName"/> or <paramref name="dataProducts"/> is null. </exception>
        public PublisherInformation(string publisherName, IEnumerable<DataProductInformation> dataProducts)
        {
            Argument.AssertNotNull(publisherName, nameof(publisherName));
            Argument.AssertNotNull(dataProducts, nameof(dataProducts));

            PublisherName = publisherName;
            DataProducts = dataProducts.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="PublisherInformation"/>. </summary>
        /// <param name="publisherName"> Name of the publisher. </param>
        /// <param name="dataProducts"> Data product information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PublisherInformation(string publisherName, IList<DataProductInformation> dataProducts, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublisherName = publisherName;
            DataProducts = dataProducts;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PublisherInformation"/> for deserialization. </summary>
        internal PublisherInformation()
        {
        }

        /// <summary> Name of the publisher. </summary>
        public string PublisherName { get; set; }
        /// <summary> Data product information. </summary>
        public IList<DataProductInformation> DataProducts { get; }
    }
}
