// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> ManagedResourceGroup related properties. </summary>
    public partial class NetworkAnalyticsManagedResourceGroupConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkAnalyticsManagedResourceGroupConfiguration"/>. </summary>
        /// <param name="name"> Name of managed resource group. </param>
        /// <param name="location"> Managed Resource Group location. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public NetworkAnalyticsManagedResourceGroupConfiguration(string name, AzureLocation location)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
            Location = location;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkAnalyticsManagedResourceGroupConfiguration"/>. </summary>
        /// <param name="name"> Name of managed resource group. </param>
        /// <param name="location"> Managed Resource Group location. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkAnalyticsManagedResourceGroupConfiguration(string name, AzureLocation location, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkAnalyticsManagedResourceGroupConfiguration"/> for deserialization. </summary>
        internal NetworkAnalyticsManagedResourceGroupConfiguration()
        {
        }

        /// <summary> Name of managed resource group. </summary>
        public string Name { get; set; }
        /// <summary> Managed Resource Group location. </summary>
        public AzureLocation Location { get; set; }
    }
}
