// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> IP rule with specific IP or IP range in CIDR format. </summary>
    public partial class NetworkAnalyticsIPRules
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkAnalyticsIPRules"/>. </summary>
        /// <param name="action"> The action of virtual network rule. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="action"/> is null. </exception>
        public NetworkAnalyticsIPRules(string action)
        {
            Argument.AssertNotNull(action, nameof(action));

            Action = action;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkAnalyticsIPRules"/>. </summary>
        /// <param name="value"> IP Rules Value. </param>
        /// <param name="action"> The action of virtual network rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkAnalyticsIPRules(string value, string action, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            Action = action;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkAnalyticsIPRules"/> for deserialization. </summary>
        internal NetworkAnalyticsIPRules()
        {
        }

        /// <summary> IP Rules Value. </summary>
        public string Value { get; set; }
        /// <summary> The action of virtual network rule. </summary>
        public string Action { get; set; }
    }
}
