// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> Specifies the default action of allow or deny when no other rules match. </summary>
    public readonly partial struct NetworkAclDefaultAction : IEquatable<NetworkAclDefaultAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkAclDefaultAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkAclDefaultAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Represents allow action. </summary>
        public static NetworkAclDefaultAction Allow { get; } = new NetworkAclDefaultAction(AllowValue);
        /// <summary> Represents deny action. </summary>
        public static NetworkAclDefaultAction Deny { get; } = new NetworkAclDefaultAction(DenyValue);
        /// <summary> Determines if two <see cref="NetworkAclDefaultAction"/> values are the same. </summary>
        public static bool operator ==(NetworkAclDefaultAction left, NetworkAclDefaultAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkAclDefaultAction"/> values are not the same. </summary>
        public static bool operator !=(NetworkAclDefaultAction left, NetworkAclDefaultAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkAclDefaultAction"/>. </summary>
        public static implicit operator NetworkAclDefaultAction(string value) => new NetworkAclDefaultAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkAclDefaultAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkAclDefaultAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
