// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> Encryption key details. </summary>
    public partial class EncryptionKeyDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EncryptionKeyDetails"/>. </summary>
        /// <param name="keyVaultUri"> The Uri of the key vault. </param>
        /// <param name="keyName"> The name of the key vault key. </param>
        /// <param name="keyVersion"> The version of the key vault key. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="keyVaultUri"/>, <paramref name="keyName"/> or <paramref name="keyVersion"/> is null. </exception>
        public EncryptionKeyDetails(Uri keyVaultUri, string keyName, string keyVersion)
        {
            Argument.AssertNotNull(keyVaultUri, nameof(keyVaultUri));
            Argument.AssertNotNull(keyName, nameof(keyName));
            Argument.AssertNotNull(keyVersion, nameof(keyVersion));

            KeyVaultUri = keyVaultUri;
            KeyName = keyName;
            KeyVersion = keyVersion;
        }

        /// <summary> Initializes a new instance of <see cref="EncryptionKeyDetails"/>. </summary>
        /// <param name="keyVaultUri"> The Uri of the key vault. </param>
        /// <param name="keyName"> The name of the key vault key. </param>
        /// <param name="keyVersion"> The version of the key vault key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EncryptionKeyDetails(Uri keyVaultUri, string keyName, string keyVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyVaultUri = keyVaultUri;
            KeyName = keyName;
            KeyVersion = keyVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EncryptionKeyDetails"/> for deserialization. </summary>
        internal EncryptionKeyDetails()
        {
        }

        /// <summary> The Uri of the key vault. </summary>
        public Uri KeyVaultUri { get; set; }
        /// <summary> The name of the key vault key. </summary>
        public string KeyName { get; set; }
        /// <summary> The version of the key vault key. </summary>
        public string KeyVersion { get; set; }
    }
}
