// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> The data type state. </summary>
    public readonly partial struct DataProductUserRole : IEquatable<DataProductUserRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataProductUserRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataProductUserRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReaderValue = "Reader";
        private const string SensitiveReaderValue = "SensitiveReader";

        /// <summary> Field to specify user of type Reader. </summary>
        public static DataProductUserRole Reader { get; } = new DataProductUserRole(ReaderValue);
        /// <summary>
        /// Field to specify user of type SensitiveReader.
        /// This user has privileged access to read sensitive data of a data product.
        /// </summary>
        public static DataProductUserRole SensitiveReader { get; } = new DataProductUserRole(SensitiveReaderValue);
        /// <summary> Determines if two <see cref="DataProductUserRole"/> values are the same. </summary>
        public static bool operator ==(DataProductUserRole left, DataProductUserRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataProductUserRole"/> values are not the same. </summary>
        public static bool operator !=(DataProductUserRole left, DataProductUserRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataProductUserRole"/>. </summary>
        public static implicit operator DataProductUserRole(string value) => new DataProductUserRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataProductUserRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataProductUserRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
