// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> The data type resource. </summary>
    public partial class DataProductDataType : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataProductDataType"/>. </summary>
        public DataProductDataType()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataProductDataType"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Latest provisioning state  of data product. </param>
        /// <param name="state"> State of data type. </param>
        /// <param name="stateReason"> Reason for the state of data type. </param>
        /// <param name="storageOutputRetention"> Field for storage output retention in days. </param>
        /// <param name="databaseCacheRetention"> Field for database cache retention in days. </param>
        /// <param name="databaseRetention"> Field for database data retention in days. </param>
        /// <param name="visualizationUri"> Url for data visualization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataProductDataType(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, NetworkAnalyticsProvisioningState? provisioningState, DataProductDataTypeState? state, string stateReason, int? storageOutputRetention, int? databaseCacheRetention, int? databaseRetention, Uri visualizationUri, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            State = state;
            StateReason = stateReason;
            StorageOutputRetention = storageOutputRetention;
            DatabaseCacheRetention = databaseCacheRetention;
            DatabaseRetention = databaseRetention;
            VisualizationUri = visualizationUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Latest provisioning state  of data product. </summary>
        public NetworkAnalyticsProvisioningState? ProvisioningState { get; }
        /// <summary> State of data type. </summary>
        public DataProductDataTypeState? State { get; set; }
        /// <summary> Reason for the state of data type. </summary>
        public string StateReason { get; }
        /// <summary> Field for storage output retention in days. </summary>
        public int? StorageOutputRetention { get; set; }
        /// <summary> Field for database cache retention in days. </summary>
        public int? DatabaseCacheRetention { get; set; }
        /// <summary> Field for database data retention in days. </summary>
        public int? DatabaseRetention { get; set; }
        /// <summary> Url for data visualization. </summary>
        public Uri VisualizationUri { get; }
    }
}
