// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> The data type state. </summary>
    public readonly partial struct DataProductControlState : IEquatable<DataProductControlState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataProductControlState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataProductControlState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Field to enable a setting. </summary>
        public static DataProductControlState Enabled { get; } = new DataProductControlState(EnabledValue);
        /// <summary> Field to disable a setting. </summary>
        public static DataProductControlState Disabled { get; } = new DataProductControlState(DisabledValue);
        /// <summary> Determines if two <see cref="DataProductControlState"/> values are the same. </summary>
        public static bool operator ==(DataProductControlState left, DataProductControlState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataProductControlState"/> values are not the same. </summary>
        public static bool operator !=(DataProductControlState left, DataProductControlState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataProductControlState"/>. </summary>
        public static implicit operator DataProductControlState(string value) => new DataProductControlState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataProductControlState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataProductControlState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
