// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkAnalytics
{
    internal class DataProductOperationSource : IOperationSource<DataProductResource>
    {
        private readonly ArmClient _client;

        internal DataProductOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataProductResource IOperationSource<DataProductResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataProductData.DeserializeDataProductData(document.RootElement);
            return new DataProductResource(_client, data);
        }

        async ValueTask<DataProductResource> IOperationSource<DataProductResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataProductData.DeserializeDataProductData(document.RootElement);
            return new DataProductResource(_client, data);
        }
    }
}
