// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.NetworkAnalytics.Mocking;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.NetworkAnalytics
{
    /// <summary> A class to add extension methods to Azure.ResourceManager.NetworkAnalytics. </summary>
    public static partial class NetworkAnalyticsExtensions
    {
        private static MockableNetworkAnalyticsArmClient GetMockableNetworkAnalyticsArmClient(ArmClient client)
        {
            return client.GetCachedClient(client0 => new MockableNetworkAnalyticsArmClient(client0));
        }

        private static MockableNetworkAnalyticsResourceGroupResource GetMockableNetworkAnalyticsResourceGroupResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableNetworkAnalyticsResourceGroupResource(client, resource.Id));
        }

        private static MockableNetworkAnalyticsSubscriptionResource GetMockableNetworkAnalyticsSubscriptionResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableNetworkAnalyticsSubscriptionResource(client, resource.Id));
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataProductResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataProductResource.CreateResourceIdentifier" /> to create a <see cref="DataProductResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsArmClient.GetDataProductResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="DataProductResource"/> object. </returns>
        public static DataProductResource GetDataProductResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableNetworkAnalyticsArmClient(client).GetDataProductResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataProductsCatalogResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataProductsCatalogResource.CreateResourceIdentifier" /> to create a <see cref="DataProductsCatalogResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsArmClient.GetDataProductsCatalogResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="DataProductsCatalogResource"/> object. </returns>
        public static DataProductsCatalogResource GetDataProductsCatalogResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableNetworkAnalyticsArmClient(client).GetDataProductsCatalogResource(id);
        }

        /// <summary>
        /// Gets a collection of DataProductResources in the ResourceGroupResource.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsResourceGroupResource.GetDataProducts()"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> is null. </exception>
        /// <returns> An object representing collection of DataProductResources and their operations over a DataProductResource. </returns>
        public static DataProductCollection GetDataProducts(this ResourceGroupResource resourceGroupResource)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableNetworkAnalyticsResourceGroupResource(resourceGroupResource).GetDataProducts();
        }

        /// <summary>
        /// Retrieve data product resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataProducts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProductResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsResourceGroupResource.GetDataProductAsync(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <param name="dataProductName"> The data product resource name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> or <paramref name="dataProductName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dataProductName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<DataProductResource>> GetDataProductAsync(this ResourceGroupResource resourceGroupResource, string dataProductName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return await GetMockableNetworkAnalyticsResourceGroupResource(resourceGroupResource).GetDataProductAsync(dataProductName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Retrieve data product resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataProducts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProductResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsResourceGroupResource.GetDataProduct(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <param name="dataProductName"> The data product resource name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> or <paramref name="dataProductName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dataProductName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<DataProductResource> GetDataProduct(this ResourceGroupResource resourceGroupResource, string dataProductName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableNetworkAnalyticsResourceGroupResource(resourceGroupResource).GetDataProduct(dataProductName, cancellationToken);
        }

        /// <summary>
        /// Gets an object representing a DataProductsCatalogResource along with the instance operations that can be performed on it in the ResourceGroupResource.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsResourceGroupResource.GetDataProductsCatalog()"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> is null. </exception>
        /// <returns> Returns a <see cref="DataProductsCatalogResource"/> object. </returns>
        public static DataProductsCatalogResource GetDataProductsCatalog(this ResourceGroupResource resourceGroupResource)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableNetworkAnalyticsResourceGroupResource(resourceGroupResource).GetDataProductsCatalog();
        }

        /// <summary>
        /// List data products by subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.NetworkAnalytics/dataProducts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataProducts_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProductResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsSubscriptionResource.GetDataProducts(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> An async collection of <see cref="DataProductResource"/> that may take multiple service requests to iterate over. </returns>
        public static AsyncPageable<DataProductResource> GetDataProductsAsync(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableNetworkAnalyticsSubscriptionResource(subscriptionResource).GetDataProductsAsync(cancellationToken);
        }

        /// <summary>
        /// List data products by subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.NetworkAnalytics/dataProducts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataProducts_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProductResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsSubscriptionResource.GetDataProducts(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> A collection of <see cref="DataProductResource"/> that may take multiple service requests to iterate over. </returns>
        public static Pageable<DataProductResource> GetDataProducts(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableNetworkAnalyticsSubscriptionResource(subscriptionResource).GetDataProducts(cancellationToken);
        }

        /// <summary>
        /// List data catalog by subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.NetworkAnalytics/dataProductsCatalogs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataProductsCatalogs_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProductsCatalogResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsSubscriptionResource.GetDataProductsCatalogs(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> An async collection of <see cref="DataProductsCatalogResource"/> that may take multiple service requests to iterate over. </returns>
        public static AsyncPageable<DataProductsCatalogResource> GetDataProductsCatalogsAsync(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableNetworkAnalyticsSubscriptionResource(subscriptionResource).GetDataProductsCatalogsAsync(cancellationToken);
        }

        /// <summary>
        /// List data catalog by subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.NetworkAnalytics/dataProductsCatalogs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataProductsCatalogs_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProductsCatalogResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableNetworkAnalyticsSubscriptionResource.GetDataProductsCatalogs(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> A collection of <see cref="DataProductsCatalogResource"/> that may take multiple service requests to iterate over. </returns>
        public static Pageable<DataProductsCatalogResource> GetDataProductsCatalogs(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableNetworkAnalyticsSubscriptionResource(subscriptionResource).GetDataProductsCatalogs(cancellationToken);
        }
    }
}
