// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.NetworkAnalytics
{
    /// <summary>
    /// A Class representing a DataProductsCatalog along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="DataProductsCatalogResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetDataProductsCatalogResource method.
    /// Otherwise you can get one from its parent resource <see cref="ResourceGroupResource"/> using the GetDataProductsCatalog method.
    /// </summary>
    public partial class DataProductsCatalogResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="DataProductsCatalogResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProductsCatalogs/default";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _dataProductsCatalogClientDiagnostics;
        private readonly DataProductsCatalogsRestOperations _dataProductsCatalogRestClient;
        private readonly DataProductsCatalogData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.NetworkAnalytics/dataProductsCatalogs";

        /// <summary> Initializes a new instance of the <see cref="DataProductsCatalogResource"/> class for mocking. </summary>
        protected DataProductsCatalogResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DataProductsCatalogResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal DataProductsCatalogResource(ArmClient client, DataProductsCatalogData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="DataProductsCatalogResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal DataProductsCatalogResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dataProductsCatalogClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.NetworkAnalytics", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string dataProductsCatalogApiVersion);
            _dataProductsCatalogRestClient = new DataProductsCatalogsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dataProductsCatalogApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual DataProductsCatalogData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Retrieve data type resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProductsCatalogs/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataProductsCatalogs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProductsCatalogResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<DataProductsCatalogResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _dataProductsCatalogClientDiagnostics.CreateScope("DataProductsCatalogResource.Get");
            scope.Start();
            try
            {
                var response = await _dataProductsCatalogRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataProductsCatalogResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieve data type resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProductsCatalogs/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataProductsCatalogs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProductsCatalogResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<DataProductsCatalogResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _dataProductsCatalogClientDiagnostics.CreateScope("DataProductsCatalogResource.Get");
            scope.Start();
            try
            {
                var response = _dataProductsCatalogRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataProductsCatalogResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
